/******************************************************************************
*                                                  
*  (c) copyright Freescale Semiconductor 2008
*  ALL RIGHTS RESERVED
*
*  File Name: usr_entry.c
*                                                                          
*  Purpose: This file is for a USB Mass-Storage Device bootloader.  This file 
*           is the initial entry point for the bootloader
*                                                                          
*  Assembler:  Codewarrior for Microcontrollers V6.2
*                                            
*  Version:  1.1
*                                                                          
*                                                                          
*  Author: Derek Snell                             
*                                                                                       
*  Location: Indianapolis, IN. USA                                            
*                                                                                  
* UPDATED HISTORY:
*
* REV   YYYY.MM.DD  AUTHOR        DESCRIPTION OF CHANGE
* ---   ----------  ------        --------------------- 
* 1.1   2008.09.26  Derek Snell   Check for user entry vector in flash
* 1.0   2008.06.10  Derek Snell   Initial version
* 
*
******************************************************************************/                                                                        
/* Freescale  is  not  obligated  to  provide  any  support, upgrades or new */
/* releases  of  the Software. Freescale may make changes to the Software at */
/* any time, without any obligation to notify or provide updated versions of */
/* the  Software  to you. Freescale expressly disclaims any warranty for the */
/* Software.  The  Software is provided as is, without warranty of any kind, */
/* either  express  or  implied,  including, without limitation, the implied */
/* warranties  of  merchantability,  fitness  for  a  particular purpose, or */
/* non-infringement.  You  assume  the entire risk arising out of the use or */
/* performance of the Software, or any systems you design using the software */
/* (if  any).  Nothing  may  be construed as a warranty or representation by */
/* Freescale  that  the  Software  or  any derivative work developed with or */
/* incorporating  the  Software  will  be  free  from  infringement  of  the */
/* intellectual property rights of third parties. In no event will Freescale */
/* be  liable,  whether in contract, tort, or otherwise, for any incidental, */
/* special,  indirect, consequential or punitive damages, including, but not */
/* limited  to,  damages  for  any loss of use, loss of time, inconvenience, */
/* commercial loss, or lost profits, savings, or revenues to the full extent */
/* such  may be disclaimed by law. The Software is not fault tolerant and is */
/* not  designed,  manufactured  or  intended by Freescale for incorporation */
/* into  products intended for use or resale in on-line control equipment in */
/* hazardous, dangerous to life or potentially life-threatening environments */
/* requiring  fail-safe  performance,  such  as  in the operation of nuclear */
/* facilities,  aircraft  navigation  or  communication systems, air traffic */
/* control,  direct  life  support machines or weapons systems, in which the */
/* failure  of  products  could  lead  directly to death, personal injury or */
/* severe  physical  or  environmental  damage  (High  Risk Activities). You */
/* specifically  represent and warrant that you will not use the Software or */
/* any  derivative  work of the Software for High Risk Activities.           */
/* Freescale  and the Freescale logos are registered trademarks of Freescale */
/* Semiconductor Inc.                                                        */ 
/*****************************************************************************/

#include "derivative.h"
#include "Bootloader_V1.h"


void _Entry(void)
{
   byte i;
   dword* UserEntryCheck;
   
  PTGDD_PTGDD0 = 0;               // PTG0 is input
  PTGPE_PTGPE0 = 1;               // internal pullup for PTG0
  
  // delay some time for oscillator and GPIO stable
  for(i=0;i<3;i++) {
    
    __RESET_WATCHDOG();
  }
 
  
  if(PTGD_PTGD0) 
  {
      UserEntryCheck = (dword*)USER_ENTRY_ADDRESS;
  	  if(*UserEntryCheck == 0x4E714EF9) 			  // check there is a valid jump op-code
  	  {
  		     UserEntryCheck++;						        // increment pointer to next long word
  		     if(*UserEntryCheck != 0xFFFFFFFF) 		// check there is a valid jump vector
  		     {
               asm (JMP USER_ENTRY_ADDRESS);    // jump to user entry
  		     }
  	  }
       
  } 
  
  SOPT1 = 0x00;                     // disable COP
  SOPT2 = 0x00;       
    
  MCGC2 = 0x36;
  while(!(MCGSC & 0x02)){};		      //wait for the OSC stable
  MCGC1 = 0x98;
  while((MCGSC & 0x1C )!= 0x08){}; // external clock is selected
	MCGC3 = 0x48;
	while ((MCGSC & 0x48) != 0x48){};	//wait for the PLL is locked
	MCGC1 = 0x18;
  while((MCGSC & 0x6C) != 0x6C){};
    
  Bootloader_Main();
}